/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.details;

import com.mojang.serialization.DynamicOps;
import dan200.computercraft.shared.CommonHooks;
import dan200.computercraft.shared.details.DetailHelpers;
import dan200.computercraft.shared.util.NBTUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1803;
import net.minecraft.class_1833;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2682;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_9290;
import net.minecraft.class_9300;
import net.minecraft.class_9304;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jspecify.annotations.Nullable;

public class ItemDetails {
    public static void fillBasic(Map<? super String, Object> data, class_1799 stack) {
        data.put("name", DetailHelpers.getId(class_7923.field_41178, stack.method_7909()));
        data.put("count", stack.method_7947());
        String hash = ItemDetails.getComponentHash(stack.method_57380());
        if (hash != null) {
            data.put("nbt", hash);
        }
    }

    private static @Nullable String getComponentHash(class_9326 components) {
        if (components.method_57848()) {
            return null;
        }
        MinecraftServer server = CommonHooks.getServer();
        class_5455.class_6890 registries = server == null ? class_5455.field_40585 : server.method_30611();
        class_2520 nbt = class_9326.field_49589.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registries), (Object)components).result().orElse(null);
        return NBTUtil.getNBTHash(nbt);
    }

    public static void fill(Map<? super String, Object> data, class_1799 stack) {
        class_9300 unbreakable;
        List<Map<String, Object>> effects;
        List<Map<String, Object>> enchants;
        data.put("displayName", stack.method_7964().getString());
        data.put("maxCount", stack.method_7914());
        if (stack.method_7963()) {
            data.put("damage", stack.method_7919());
            data.put("maxDamage", stack.method_7936());
        }
        if (stack.method_7909().method_31567(stack)) {
            data.put("durability", (double)stack.method_7909().method_31569(stack) / 13.0);
        }
        data.put("tags", DetailHelpers.getTags(stack.method_40133()));
        data.put("itemGroups", ItemDetails.getItemGroups(stack));
        class_9290 lore = (class_9290)stack.method_57824(class_9334.field_49632);
        if (lore != null && !lore.comp_2400().isEmpty()) {
            data.put("lore", lore.comp_2400().stream().map(class_2561::getString).toList());
        }
        if (!(enchants = ItemDetails.getAllEnchants(stack)).isEmpty()) {
            data.put("enchantments", enchants);
        }
        if (!(effects = ItemDetails.getAllEffects(stack)).isEmpty()) {
            data.put("potionEffects", effects);
        }
        if ((unbreakable = (class_9300)stack.method_57824(class_9334.field_49630)) != null && unbreakable.comp_2417()) {
            data.put("unbreakable", true);
        }
        DetailHelpers.fillMapColour(data, (class_1922)class_2682.field_12294, class_2338.field_10980, class_2248.method_9503((class_1792)stack.method_7909()).method_9564());
    }

    private static List<Map<String, Object>> getItemGroups(class_1799 stack) {
        return class_7706.method_47341().stream().filter(x -> x.method_47311() && x.method_47312() == class_1761.class_7916.field_41052 && x.method_45412(stack)).map(group -> {
            HashMap<String, String> groupData = new HashMap<String, String>(2);
            class_2960 id = class_7923.field_44687.method_10221(group);
            if (id != null) {
                groupData.put("id", id.toString());
            }
            groupData.put("displayName", group.method_7737().getString());
            return groupData;
        }).toList();
    }

    private static List<Map<String, Object>> getAllEnchants(class_1799 stack) {
        ArrayList<Map<String, Object>> enchants = new ArrayList<Map<String, Object>>(0);
        ItemDetails.addEnchantments((class_9304)stack.method_57824(class_9334.field_49643), enchants);
        ItemDetails.addEnchantments((class_9304)stack.method_57824(class_9334.field_49633), enchants);
        return enchants;
    }

    private static void addEnchantments(@Nullable class_9304 rawEnchants, ArrayList<Map<String, Object>> enchants) {
        if (rawEnchants == null || rawEnchants.method_57543()) {
            return;
        }
        enchants.ensureCapacity(enchants.size() + rawEnchants.method_57541());
        for (Object2IntMap.Entry entry : rawEnchants.method_57539()) {
            class_6880 enchantment = (class_6880)entry.getKey();
            int level = entry.getIntValue();
            HashMap<String, Object> enchant = new HashMap<String, Object>(3);
            enchant.put("name", enchantment.method_55840());
            enchant.put("level", level);
            enchant.put("displayName", class_1887.method_8179((class_6880)enchantment, (int)level).getString());
            enchants.add(enchant);
        }
    }

    private static List<Map<String, Object>> getAllEffects(class_1799 stack) {
        class_1844 effects = (class_1844)stack.method_57824(class_9334.field_49651);
        if (effects == null) {
            return List.of();
        }
        return StreamSupport.stream(effects.method_57397().spliterator(), false).map(p -> {
            HashMap<String, Object> potion = new HashMap<String, Object>(4);
            potion.put("name", p.method_5579().method_55840());
            class_5250 displayName = class_2561.method_43471((String)p.method_5586());
            if (p.method_5578() > 0) {
                displayName = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{displayName, class_2561.method_43471((String)("potion.potency." + p.method_5578()))});
            }
            potion.put("displayName", displayName.getString());
            if (p.method_5578() > 0) {
                potion.put("potency", p.method_5578() + 1);
            }
            if (p.method_48559()) {
                potion.put("duration", Double.POSITIVE_INFINITY);
            } else if (p.method_5584() > 1) {
                potion.put("duration", (double)p.method_5584() / 20.0 * ItemDetails.getPotionDurationMultiplier(stack));
            }
            return potion;
        }).toList();
    }

    private static double getPotionDurationMultiplier(class_1799 stack) {
        if (stack.method_7909() instanceof class_1803) {
            return 0.25;
        }
        if (stack.method_7909() instanceof class_1833) {
            return 0.125;
        }
        return 1.0;
    }
}

